/*{
	"GUID":"BAC37FE1-0A77-4dca-9C45-2FDFE66F3D46"
}*/

//author: RuanShengQiang 
//date: 2017/6/13

#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define _max(a,b) (a)>(b)?(a):(b)
#define _min(a,b) (a)<(b)?(a):(b)
#define _abs(a)	(float4)( (a).x>0.0f?(a).x:-(a).x, (a).y>0.0f?(a).y:-(a).y, (a).z>0.0f?(a).z:-(a).z, (a).w>0.0f?(a).w:-(a).w)
#define SRC src_data
#define OVERLAY1 ovelay1

//uniform vec2 PREFIX(offset)[9];
const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;
vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

__kernel void MAIN(
      __read_only image2d_t src_data,
      __write_only image2d_t dest_data,        //Data in global memory
       __global FilterParam* param,
	  int alpha) //range[0 - 100] // the gpu items/threads should be newW*newH
{
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	
	int2 coordinate = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	float2 iResolution = (float2)(W,H);
	vec2 tc = (fragCoord + (float2)(0.5f)) / (float2)(W,H);
	
	vec4 tempColor;
	vec2 offset[9] = 
                { 
                        (vec2)(-1.0f/W, -1.0f/H), 
                        (vec2)(0.0f, -1.0f/H), 
                        (vec2)(1.0f/W, -1.0f/H), 
                        (vec2)(-1.0f/W,    0.0f), 
                        (vec2)(0.0f,    0.0f), 
                        (vec2)(1.0f/W,    0.0f), 
                        (vec2)(-1.0f/W,  1.0f/H), 
                        (vec2)(0.0f,  1.0f/H), 
                        (vec2)(1.0f/W,  1.0f/H)
                };
				
    vec4 sample[9];
    for(int i=0; i < 9; i++)
    {
        sample[i] = INPUT(src_data, param, tc + offset[i]);
    }
	vec4 inColor = INPUT(src_data, param, tc);
    tempColor = -sample[0] - sample[1] - sample[2] - sample[3] + sample[4] * 9.0f - sample[5] - sample[6] - sample[7] - sample[8];    
    tempColor.rgb = 0.627f* exp(tempColor.rgb * 0.3634f)  - 0.5467f * exp(-tempColor.rgb * 10.891f);
	
		
	float fAlpha = (float)alpha/100.0f;
	float4 tuneColor = tempColor ;
	float4 origColor = INPUT(src_data, param, tc);
	float4 outputColor = tuneColor * fAlpha + origColor * (1.0f - fAlpha);
	
	write_imagef(dest_data, coordinate, outputColor);
 
}
